﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/imagebuilder/Imagebuilder_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace imagebuilder {
namespace Model {
class DeleteWorkflowResult {
 public:
  AWS_IMAGEBUILDER_API DeleteWorkflowResult() = default;
  AWS_IMAGEBUILDER_API DeleteWorkflowResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IMAGEBUILDER_API DeleteWorkflowResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the workflow resource that this request
   * deleted.</p>
   */
  inline const Aws::String& GetWorkflowBuildVersionArn() const { return m_workflowBuildVersionArn; }
  template <typename WorkflowBuildVersionArnT = Aws::String>
  void SetWorkflowBuildVersionArn(WorkflowBuildVersionArnT&& value) {
    m_workflowBuildVersionArnHasBeenSet = true;
    m_workflowBuildVersionArn = std::forward<WorkflowBuildVersionArnT>(value);
  }
  template <typename WorkflowBuildVersionArnT = Aws::String>
  DeleteWorkflowResult& WithWorkflowBuildVersionArn(WorkflowBuildVersionArnT&& value) {
    SetWorkflowBuildVersionArn(std::forward<WorkflowBuildVersionArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DeleteWorkflowResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_workflowBuildVersionArn;
  bool m_workflowBuildVersionArnHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace imagebuilder
}  // namespace Aws
