# The PEP 484 type hints stub file for the QtHelp module.
#
# Generated by SIP 6.15.0
#
# Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt6.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import collections, re, typing, enum

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt6.sip

from PyQt6 import QtCore
from PyQt6 import QtGui
from PyQt6 import QtWidgets

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[collections.abc.Callable[..., Any], QtCore.pyqtBoundSignal]


class QCompressedHelpInfo(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QCompressedHelpInfo') -> None: ...

    def isNull(self) -> bool: ...
    @staticmethod
    def fromCompressedHelpFile(documentationFileName: str|None) -> 'QCompressedHelpInfo': ...
    def version(self) -> QtCore.QVersionNumber: ...
    def component(self) -> str: ...
    def namespaceName(self) -> str: ...
    def swap(self, other: 'QCompressedHelpInfo') -> None: ...


class QHelpContentItem(PyQt6.sip.simplewrapper):

    def childPosition(self, child: 'QHelpContentItem|None') -> int: ...
    def parent(self) -> 'QHelpContentItem|None': ...
    def row(self) -> int: ...
    def url(self) -> QtCore.QUrl: ...
    def title(self) -> str: ...
    def childCount(self) -> int: ...
    def child(self, row: int) -> 'QHelpContentItem|None': ...


class QHelpContentModel(QtCore.QAbstractItemModel):

    contentsCreated: typing.ClassVar[QtCore.pyqtSignal]
    contentsCreationStarted: typing.ClassVar[QtCore.pyqtSignal]
    def isCreatingContents(self) -> bool: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def parent(self, index: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...
    def contentItemAt(self, index: QtCore.QModelIndex) -> QHelpContentItem|None: ...
    def createContentsForCurrentFilter(self) -> None: ...
    def createContents(self, customFilterName: str|None) -> None: ...


class QHelpContentWidget(QtWidgets.QTreeView):

    linkActivated: typing.ClassVar[QtCore.pyqtSignal]
    def indexOf(self, link: QtCore.QUrl) -> QtCore.QModelIndex: ...


class QHelpEngineCore(QtCore.QObject):

    def __init__(self, collectionFile: str|None, parent: QtCore.QObject|None = ...) -> None: ...

    def setReadOnly(self, enable: bool) -> None: ...
    def isReadOnly(self) -> bool: ...
    @typing.overload
    def documentsForKeyword(self, keyword: str|None) -> list['QHelpLink']: ...
    @typing.overload
    def documentsForKeyword(self, keyword: str|None, filterName: str|None) -> list['QHelpLink']: ...
    @typing.overload
    def documentsForIdentifier(self, id: str|None) -> list['QHelpLink']: ...
    @typing.overload
    def documentsForIdentifier(self, id: str|None, filterName: str|None) -> list['QHelpLink']: ...
    def usesFilterEngine(self) -> bool: ...
    def setUsesFilterEngine(self, uses: bool) -> None: ...
    def files(self, namespaceName: str|None, filterName: str|None, extensionFilter: str|None = ...) -> list[QtCore.QUrl]: ...
    def filterEngine(self) -> 'QHelpFilterEngine|None': ...
    warning: typing.ClassVar[QtCore.pyqtSignal]
    setupFinished: typing.ClassVar[QtCore.pyqtSignal]
    setupStarted: typing.ClassVar[QtCore.pyqtSignal]
    def setAutoSaveFilter(self, save: bool) -> None: ...
    def autoSaveFilter(self) -> bool: ...
    def error(self) -> str: ...
    @staticmethod
    def metaData(documentationFileName: str|None, name: str|None) -> typing.Any: ...
    def setCustomValue(self, key: str|None, value: typing.Any) -> bool: ...
    def customValue(self, key: str|None, defaultValue: typing.Any = ...) -> typing.Any: ...
    def removeCustomValue(self, key: str|None) -> bool: ...
    def fileData(self, url: QtCore.QUrl) -> QtCore.QByteArray: ...
    def findFile(self, url: QtCore.QUrl) -> QtCore.QUrl: ...
    def registeredDocumentations(self) -> list[str]: ...
    def documentationFileName(self, namespaceName: str|None) -> str: ...
    def unregisterDocumentation(self, namespaceName: str|None) -> bool: ...
    def registerDocumentation(self, documentationFileName: str|None) -> bool: ...
    @staticmethod
    def namespaceName(documentationFileName: str|None) -> str: ...
    def copyCollectionFile(self, fileName: str|None) -> bool: ...
    def setCollectionFile(self, fileName: str|None) -> None: ...
    def collectionFile(self) -> str: ...
    def setupData(self) -> bool: ...


class QHelpEngine(QHelpEngineCore):

    def __init__(self, collectionFile: str|None, parent: QtCore.QObject|None = ...) -> None: ...

    def searchEngine(self) -> 'QHelpSearchEngine|None': ...
    def indexWidget(self) -> 'QHelpIndexWidget|None': ...
    def contentWidget(self) -> QHelpContentWidget|None: ...
    def indexModel(self) -> 'QHelpIndexModel|None': ...
    def contentModel(self) -> QHelpContentModel|None: ...


class QHelpFilterData(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QHelpFilterData') -> None: ...

    def __ne__(self, other: object): ...
    def versions(self) -> list[QtCore.QVersionNumber]: ...
    def components(self) -> list[str]: ...
    def setVersions(self, versions: collections.abc.Iterable[QtCore.QVersionNumber]) -> None: ...
    def setComponents(self, components: collections.abc.Iterable[str|None]) -> None: ...
    def swap(self, other: 'QHelpFilterData') -> None: ...
    def __eq__(self, other: object): ...


class QHelpFilterEngine(QtCore.QObject):

    @typing.overload
    def indices(self) -> list[str]: ...
    @typing.overload
    def indices(self, filterName: str|None) -> list[str]: ...
    def availableVersions(self) -> list[QtCore.QVersionNumber]: ...
    filterActivated: typing.ClassVar[QtCore.pyqtSignal]
    def namespacesForFilter(self, filterName: str|None) -> list[str]: ...
    def removeFilter(self, filterName: str|None) -> bool: ...
    def setFilterData(self, filterName: str|None, filterData: QHelpFilterData) -> bool: ...
    def filterData(self, filterName: str|None) -> QHelpFilterData: ...
    def availableComponents(self) -> list[str]: ...
    def setActiveFilter(self, filterName: str|None) -> bool: ...
    def activeFilter(self) -> str: ...
    def filters(self) -> list[str]: ...
    def namespaceToVersion(self) -> dict[str, QtCore.QVersionNumber]: ...
    def namespaceToComponent(self) -> dict[str, str]: ...


class QHelpFilterSettingsWidget(QtWidgets.QWidget):

    def __init__(self, parent: QtWidgets.QWidget|None = ...) -> None: ...

    def applySettings(self, filterEngine: QHelpFilterEngine|None) -> bool: ...
    def readSettings(self, filterEngine: QHelpFilterEngine|None) -> None: ...
    def setAvailableVersions(self, versions: collections.abc.Iterable[QtCore.QVersionNumber]) -> None: ...
    def setAvailableComponents(self, components: collections.abc.Iterable[str|None]) -> None: ...


class QHelpIndexModel(QtCore.QStringListModel):

    indexCreated: typing.ClassVar[QtCore.pyqtSignal]
    indexCreationStarted: typing.ClassVar[QtCore.pyqtSignal]
    def isCreatingIndex(self) -> bool: ...
    def filter(self, filter: str|None, wildcard: str|None = ...) -> QtCore.QModelIndex: ...
    def createIndexForCurrentFilter(self) -> None: ...
    def createIndex(self, customFilterName: str|None) -> None: ...
    def helpEngine(self) -> QHelpEngineCore|None: ...


class QHelpIndexWidget(QtWidgets.QListView):

    documentsActivated: typing.ClassVar[QtCore.pyqtSignal]
    documentActivated: typing.ClassVar[QtCore.pyqtSignal]
    def activateCurrentItem(self) -> None: ...
    def filterIndices(self, filter: str|None, wildcard: str|None = ...) -> None: ...


class QHelpLink(PyQt6.sip.simplewrapper):

    title = ... # type: str|None
    url = ... # type: QtCore.QUrl

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QHelpLink') -> None: ...


class QHelpSearchQuery(PyQt6.sip.simplewrapper):

    class FieldName(enum.Enum):
        DEFAULT = ... # type: QHelpSearchQuery.FieldName
        FUZZY = ... # type: QHelpSearchQuery.FieldName
        WITHOUT = ... # type: QHelpSearchQuery.FieldName
        PHRASE = ... # type: QHelpSearchQuery.FieldName
        ALL = ... # type: QHelpSearchQuery.FieldName
        ATLEAST = ... # type: QHelpSearchQuery.FieldName

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, field: 'QHelpSearchQuery.FieldName', wordList: collections.abc.Iterable[str|None]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QHelpSearchQuery') -> None: ...


class QHelpSearchEngine(QtCore.QObject):

    def __init__(self, helpEngine: QHelpEngineCore|None, parent: QtCore.QObject|None = ...) -> None: ...

    def search(self, searchInput: str|None) -> None: ...
    def searchInput(self) -> str: ...
    def searchResults(self, start: int, end: int) -> list['QHelpSearchResult']: ...
    def searchResultCount(self) -> int: ...
    searchingFinished: typing.ClassVar[QtCore.pyqtSignal]
    searchingStarted: typing.ClassVar[QtCore.pyqtSignal]
    indexingFinished: typing.ClassVar[QtCore.pyqtSignal]
    indexingStarted: typing.ClassVar[QtCore.pyqtSignal]
    def cancelSearching(self) -> None: ...
    def cancelIndexing(self) -> None: ...
    def reindexDocumentation(self) -> None: ...
    def resultWidget(self) -> 'QHelpSearchResultWidget|None': ...
    def queryWidget(self) -> 'QHelpSearchQueryWidget|None': ...


class QHelpSearchEngineCore(QtCore.QObject):

    def __init__(self, helpEngine: QHelpEngineCore|None, parent: QtCore.QObject|None = ...) -> None: ...

    searchingFinished: typing.ClassVar[QtCore.pyqtSignal]
    searchingStarted: typing.ClassVar[QtCore.pyqtSignal]
    indexingFinished: typing.ClassVar[QtCore.pyqtSignal]
    indexingStarted: typing.ClassVar[QtCore.pyqtSignal]
    def cancelSearching(self) -> None: ...
    def search(self, searchInput: str|None) -> None: ...
    def cancelIndexing(self) -> None: ...
    def reindexDocumentation(self) -> None: ...
    def searchInput(self) -> str: ...
    def searchResults(self, start: int, end: int) -> list['QHelpSearchResult']: ...
    def searchResultCount(self) -> int: ...


class QHelpSearchQueryWidget(QtWidgets.QWidget):

    def __init__(self, parent: QtWidgets.QWidget|None = ...) -> None: ...

    def setSearchInput(self, searchInput: str|None) -> None: ...
    def searchInput(self) -> str: ...
    def setCompactMode(self, on: bool) -> None: ...
    def isCompactMode(self) -> bool: ...
    search: typing.ClassVar[QtCore.pyqtSignal]
    def collapseExtendedSearch(self) -> None: ...
    def expandExtendedSearch(self) -> None: ...


class QHelpSearchResult(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QHelpSearchResult') -> None: ...
    @typing.overload
    def __init__(self, url: QtCore.QUrl, title: str|None, snippet: str|None) -> None: ...

    def snippet(self) -> str: ...
    def url(self) -> QtCore.QUrl: ...
    def title(self) -> str: ...


class QHelpSearchResultWidget(QtWidgets.QWidget):

    requestShowLink: typing.ClassVar[QtCore.pyqtSignal]
    def linkAt(self, point: QtCore.QPoint) -> QtCore.QUrl: ...
